<?php

namespace App\Http\Controllers\TherapistCommunitys;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;
use App\Http\Requests\TherapistCommunitys\TherapistCommunityServices\CreateRequest;
use App\Http\Resources\Web\ServicesResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistCommunityServicesController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
      $this->middleware('auth');
      $this->middleware('therapist_community');
      // $this->middleware('permission:therapist_community_services.index');
      // $this->middleware('permission:therapist_community_services.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_community_services.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_community_services.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_community_services.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_community_services.import',['only' => ['import']])
      // $this->middleware('permission:therapist_community_services.update|therapist_community_services.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist_community = auth()->user()->therapist_community;
    if($req != null){
      $therapist_community_services =  $therapist_community->therapist_community_services()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_community_services =  $therapist_community_services->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_community_services =  $therapist_community_services->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_community_services = $therapist_community_services->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_community_services = $therapist_community_services->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_community_services = $therapist_community_services->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_community_services = $therapist_community_services->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_community_services = $therapist_community_services->get();
        return $therapist_community_services;
      }
      $totalTherapistCommunityServices = $therapist_community_services->count();
      $therapist_community_services = $therapist_community_services->paginate($req->perPage);
      $therapist_community_services = ServicesResource::collection($therapist_community_services)->response()->getData(true);

      return $therapist_community_services;
    }
    $therapist_community_services = ServicesResource::collection($therapist_community->therapist_community_services()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_community_services;
  }

  /********* FETCH ALL TherapistCommunityServices ***********/
    public function index()
    {
        $therapist_community_services =  $this->getter();
        $response = generateResponse($therapist_community_services,count($therapist_community_services['data']) > 0 ? true:false,'TherapistCommunityServices Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistCommunityServices FOR Search ***********/
   public function filter(Request $request){
     $therapist_community_services = $this->getter($request);
     $response = generateResponse($therapist_community_services,count($therapist_community_services['data']) > 0 ? true:false,'Filter TherapistCommunityServices Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistCommunityService ***********/
    public function store(CreateRequest $request)
    {
        $settings = generalSettings();
      $therapist_community = auth()->user()->therapist_community;
      try{
      DB::beginTransaction();
      $request->merge(['created_by_user_id'=>auth()->user()->id]);
      $data = $request->all();
      $data['image'] = uploadCroppedFile($request,'image','therapist_community_services');
      $data['audio'] = uploadFile($request,'audio','therapist_community_services');
      $data['video'] = uploadFile($request,'video','therapist_community_services');
      $therapist_community_service = $therapist_community->therapist_community_services()->create($data);
      $therapist_community_service->slug = Str::slug($therapist_community_service->name . ' ' . $therapist_community_service->id, '-');
      if((int)$settings['auto_approve_therapist_community_service']){
        $therapist_community_service->is_approved = 1;
        $therapist_community_service->approved_at = now();
      }
      $therapist_community_service->save();
      $therapist_community_service = $therapist_community->therapist_community_services()->withAll()->find($therapist_community_service->id);
      $therapist_community_service = new ServicesResource($therapist_community_service);
      $therapist_community_service->tags()->sync($request->tag_ids);
      if($request->faqs){
        $therapist_community_service->faqs()->createMany($request->faqs);
      }
      DB::commit();
    }
      catch (\Exception $e) {
        DB::rollBack();
        request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
     }
      return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show( $therapist_community_service)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_service->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_service = $therapist_community->therapist_community_services()->withAll()->find($therapist_community_service);
        if($therapist_community_service){
          $therapist_community_service = new ServicesResource($therapist_community_service);
          $response = generateResponse($therapist_community_service,true,'TherapistCommunityService Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunityService Not FOund',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistCommunityService ***********/
    public function update(CreateRequest $request, Service $therapist_community_service)
    {
        // dd($request->all());
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_service->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->image) {
            $data['image'] = uploadCroppedFile($request,'image','therapist_community_services',$therapist_community_service->image);
        } else {
            $data['image'] = $therapist_community_service->image;
        }

        if ($request->audio) {
            $data['audio'] = uploadFile($request,'audio','therapist_community_services');
        } else {
            $data['audio'] = $therapist_community_service->audio;
        }

        if ($request->video) {
            $data['video'] = uploadFile($request,'video','therapist_community_services');
        } else {
            $data['video'] = $therapist_community_service->video;
        }
        $therapist_community_service->update($data);
        $therapist_community_service = $therapist_community_service->find($therapist_community_service->id);
        $slug = Str::slug($therapist_community_service['name'] . ' ' . $therapist_community_service->id, '-');
        $therapist_community_service->update(
            [
                'slug' => $slug
            ]
        );
        $therapist_community_service->tags()->sync($request->tag_ids);
        if($request->faqs){
            $therapist_community_service->faqs()->delete();
            $therapist_community_service->faqs()->createMany($request->faqs);
          }
        DB::commit();
      }
        catch (\Exception $e) {
            dd($e->getMessage());
          DB::rollBack();
          request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
       }
       return redirect()->back();
    }

    /********* UPDATE TherapistCommunityService Status***********/
    public function updateStatus(Request $request,Service $therapist_community_service){
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_service->therapist_community_id != $therapist_community->id){
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_community_service->update([
          'is_active' => $therapist_community_service->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistCommunityService Status Updated Successfully',null,'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistCommunityService ***********/
    public function destroy(Request $request,Service $therapist_community_service)
    {
        $therapist_community = auth()->user()->therapist_community;
        if($therapist_community_service->therapist_community_id != $therapist_community->id){
            request()->session()->flash('alert',['message' => 'Invalid Request','type' => 'error']);
            return redirect()->back();
        }
          if($therapist_community_service->trashed()) {
            request()->session()->flash('alert',['message' => 'Already in Trash','type' => 'error']);
          }
          else{
            $therapist_community_service->delete();
          }
          return redirect()->back();
    }
    /*********Permanently DELETE TherapistCommunityService ***********/
    public function destroyPermanently(Request $request,$therapist_community_service)
    {
        $therapist_community= auth()->user()->therapist_community;
        $therapist_community_service = $therapist_community->therapist_community_services()->withTrashed()->find($therapist_community_service);
        if($therapist_community_service){
            if($therapist_community_service->therapist_community_id != $therapist_community->id){
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
          if ($therapist_community_service->trashed()) {
            $therapist_community_service->forceDelete();
            $response = generateResponse(null,true,'TherapistCommunityService Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunityService is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistCommunityService not found',null,'object');
        }
          return response()->json($response, 200);
    }
    /********* Restore TherapistCommunityService ***********/
    public function restore(Request $request,$therapist_community_service)
    {
      $therapist_community= auth()->user()->therapist_community;
      $therapist_community_service = $therapist_community->therapist_community_services()->withTrashed()->find($therapist_community_service);
          if ($therapist_community_service->trashed()) {
            $therapist_community_service->restore();
            $response = generateResponse(null,true,'TherapistCommunityService Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCommunityService is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
